package ru.yandex.solomon.dumper;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.WillClose;

import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsResponse;
import ru.yandex.solomon.slog.Log;
import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
public interface LongTermStorage {
    boolean isAbleToCreateNewMetrics(int numId);
    CompletableFuture<TResolveLogsResponse> resolve(TResolveLogsRequest request);
    CompletableFuture<EStockpileStatusCode> write(int shardId, @WillClose List<Log> resolved);
}
