package ru.yandex.solomon.dumper;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.WillNotClose;

import ru.yandex.metabase.client.MetabaseClient;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsResponse;
import ru.yandex.solomon.slog.Log;
import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
public class LongTermStorageImpl implements LongTermStorage {
    @WillNotClose
    private StockpileWriter stockpile;
    @WillNotClose
    private MetabaseClient metabase;

    public LongTermStorageImpl(@WillNotClose StockpileWriter stockpile, @WillNotClose MetabaseClient metabase) {
        this.stockpile = stockpile;
        this.metabase = metabase;
    }

    @Override
    public boolean isAbleToCreateNewMetrics(int numId) {
        return metabase.isAllowCreateNew(numId);
    }

    @Override
    public CompletableFuture<TResolveLogsResponse> resolve(TResolveLogsRequest request) {
        return metabase.resolveLogs(request);
    }

    @Override
    public CompletableFuture<EStockpileStatusCode> write(int shardId, List<Log> resolved) {
        return stockpile.write(shardId, resolved);
    }
}
