package ru.yandex.solomon.dumper;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricImpl implements Metric {
    public static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(MetricImpl.class);
    private final int shardId;
    private final long localId;
    private final MetricType type;
    private volatile long touchedAt;

    public MetricImpl(int shardId, long localId, MetricType type) {
        this.shardId = shardId;
        this.localId = localId;
        this.type = type;
    }

    public static MetricImpl of(Metric metric) {
        if (metric instanceof MetricImpl) {
            return (MetricImpl) metric;
        }
        return new MetricImpl(metric.getShardId(), metric.getLocalId(), metric.getType());
    }

    @Override
    public int getShardId() {
        return shardId;
    }

    @Override
    public long getLocalId() {
        return localId;
    }

    @Override
    public MetricType getType() {
        return type;
    }

    public void touch(long time) {
        this.touchedAt = time;
    }

    public long getTouchTime() {
        return touchedAt;
    }
}
