package ru.yandex.solomon.dumper;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsCacheMetrics {
    public final Rate settlersEvict;
    public final Rate settlersHit;
    public final Rate settlersMiss;
    public final Rate settlersAdd;
    public final GaugeInt64 settlersSize;

    public final Rate resolvedEvict;
    public final Rate resolvedHit;
    public final Rate resolvedMiss;
    public final Rate resolvedAdd;
    public final GaugeInt64 resolvedSize;


    public MetricsCacheMetrics(MetricRegistry registry) {
        this.settlersEvict = registry.rate("metrics.cache.evict", Labels.of("type", "settlers"));
        this.settlersAdd = registry.rate("metrics.cache.add", Labels.of("type", "settlers"));
        this.settlersMiss = registry.rate("metrics.cache.miss", Labels.of("type", "settlers"));
        this.settlersHit = registry.rate("metrics.cache.hit", Labels.of("type", "settlers"));
        this.settlersSize = registry.gaugeInt64("metrics.cache.size", Labels.of("type", "settlers"));

        this.resolvedEvict = registry.rate("metrics.cache.evict", Labels.of("type", "resolved"));
        this.resolvedAdd = registry.rate("metrics.cache.add", Labels.of("type", "resolved"));
        this.resolvedMiss = registry.rate("metrics.cache.miss", Labels.of("type", "resolved"));
        this.resolvedHit = registry.rate("metrics.cache.hit", Labels.of("type", "resolved"));
        this.resolvedSize = registry.gaugeInt64("metrics.cache.size", Labels.of("type", "resolved"));
    }
}
