package ru.yandex.solomon.dumper;

import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotMetricsCache implements MetricsCache {
    private final Map<Labels, Metric> map;

    public SnapshotMetricsCache(Map<Labels, Metric> map) {
        this.map = map;
    }

    @Nullable
    @Override
    public Metric resolve(Labels labels) {
        return map.get(labels);
    }

    @Override
    public boolean containsInSettlers(Labels labels) {
        return false;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return 0;
    }
}
