package ru.yandex.solomon.dumper;

import java.util.Objects;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;
import ru.yandex.stockpile.api.EDecimPolicy;

/**
 * @author Vladimir Gordiychuk
 */
public class SolomonShardOpts extends DefaultObject {
    public final int numId;
    public final String id;
    public final String projectId;
    public final EDecimPolicy decimPolicy;

    public SolomonShardOpts(Builder builder) {
        this.numId = builder.numId;
        this.id = Objects.requireNonNull(builder.id);
        this.projectId = Objects.requireNonNull(builder.projectId);
        this.decimPolicy = Nullables.orDefault(builder.decimPolicy, EDecimPolicy.POLICY_5_MIN_AFTER_7_DAYS);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int numId;
        private String id;
        private String projectId;
        private EDecimPolicy decimPolicy;

        private Builder() {
        }

        public Builder withNumId(int numId) {
            this.numId = numId;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withDecimPolicy(EDecimPolicy decimPolicy) {
            this.decimPolicy = decimPolicy;
            return this;
        }

        public SolomonShardOpts build() {
            return new SolomonShardOpts(this);
        }
    }
}
