package ru.yandex.solomon.dumper;

import java.util.concurrent.TimeUnit;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;

/**
 * @author Vladimir Gordiychuk
 */
public class SolomonShardProcessMetrics {
    public final AsyncMetrics logResolve;
    public final Histogram inQueue;
    public final Histogram parsing;
    public final Rate parsingComplete;
    public final Rate parsingCompleteError;

    public final Rate metricsKnown;
    public final Rate metricsUnknown;
    public final Rate metricsDropped;

    public final Rate pointsKnown;
    public final Rate pointsUnknown;
    public final Rate pointsDropped;

    public final MetricsCacheMetrics cacheMetrics;

    public SolomonShardProcessMetrics(MetricRegistry registry) {
        this.logResolve = new AsyncMetrics(registry, "dumper.host.log.resolve");
        this.inQueue = registry.histogramRate("dumper.host.log.inQueue.elapsedTimeMs", Histograms.exponential(30, 2));
        this.parsing = registry.histogramRate("dumper.host.log.parsing.elapsedTimeMs", Histograms.exponential(30, 2));
        this.parsingComplete = registry.rate("dumper.host.log.parsing.completedOk");
        this.parsingCompleteError = registry.rate("dumper.host.log.parsing.completedError");

        this.metricsKnown = registry.rate("dumper.host.parsing.metricsKnown");
        this.metricsUnknown = registry.rate("dumper.host.parsing.metricsUnknown");
        this.metricsDropped = registry.rate("dumper.host.parsing.metricsDropped");

        this.pointsKnown = registry.rate("dumper.host.parsing.pointsKnown");
        this.pointsUnknown = registry.rate("dumper.host.parsing.pointsUnknown");
        this.pointsDropped = registry.rate("dumper.host.parsing.pointsDropped");

        this.cacheMetrics = new MetricsCacheMetrics(registry);
    }

    public void successParse(ParsingStats stats) {
        inQueue.record(TimeUnit.NANOSECONDS.toMillis(stats.waitingTimeNs));
        parsing.record(TimeUnit.NANOSECONDS.toMillis(stats.parsingTimeNs));
        parsingComplete.inc();
        metricsKnown.add(stats.metricsKnown);
        metricsKnown.add(stats.metricsKnown);
        metricsUnknown.add(stats.metricsUnknown);
        metricsDropped.add(stats.metricsDropped);

        pointsKnown.add(stats.pointsKnown);
        pointsUnknown.add(stats.pointsUnknown);
        pointsDropped.add(stats.pointsDropped);
    }

    public void failedParse() {
        parsingCompleteError.inc();
    }
}
