package ru.yandex.solomon.dumper;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;

/**
 * @author Vladimir Gordiychuk
 */
public class TickClock extends Clock {
    private final Clock clock;
    private volatile long now;

    public TickClock(Clock clock) {
        this.clock = clock;
        this.now = clock.millis();
    }

    @Override
    public ZoneId getZone() {
        return clock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        if (zone.equals(getZone())) {
            return this;
        }

        return new TickClock(clock.withZone(zone));
    }

    @Override
    public long millis() {
        return now;
    }

    public void tick() {
        now = clock.millis();
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(now);
    }
}
