package ru.yandex.solomon.dumper.mon;

import ru.yandex.kikimr.client.kv.KikimrKvClientImpl;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class KvMon {
    public static void addMetrics(KikimrKvClientImpl client, MetricRegistry registry) {
        var counters = client.counters;
        registry.lazyRate("ydb.kv.read.bytes", () -> counters.bytesRead.get());
        registry.lazyRate("ydb.kv.read.files", () -> counters.filesRead.get());
        registry.lazyRate("ydb.kv.write.bytes", () -> counters.bytesWritten.get());
        registry.lazyRate("ydb.kv.write.files", () -> counters.filesWritten.get());
    }
}
