package ru.yandex.solomon.dumper.mon;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.histogram.HistogramSnapshot;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsSupplierUtils {
    public static void append(String name, long value, MetricConsumer consumer) {
        append(name, Labels.empty(), value, consumer);
    }

    public static void append(String name, Labels labels, long value, MetricConsumer consumer) {
        consumer.onMetricBegin(MetricType.IGAUGE);
        consumer.onLabelsBegin(labels.size() + 1);
        labels.forEach(consumer::onLabel);
        consumer.onLabel("sensor", name);
        consumer.onLabelsEnd();
        consumer.onLong(0, value);
        consumer.onMetricEnd();
    }

    public static void append(String name, HistogramSnapshot value, MetricConsumer consumer) {
        append(name, Labels.empty(), value, consumer);
    }

    public static void append(String name, Labels labels, HistogramSnapshot value, MetricConsumer consumer) {
        consumer.onMetricBegin(MetricType.HIST);
        consumer.onLabelsBegin(labels.size() + 1);
        consumer.onLabel("sensor", name);
        consumer.onLabelsEnd();
        consumer.onHistogram(0, value);
        consumer.onMetricEnd();
    }
}
