package ru.yandex.solomon.dumper.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.db.dao.ConfigDaoContext;
import ru.yandex.solomon.core.db.dao.ShardsDao;
import ru.yandex.solomon.dumper.DumperLocalShards;
import ru.yandex.solomon.dumper.DumperShardMetricSupplier;
import ru.yandex.solomon.dumper.DumperShardMetricsAggregated;
import ru.yandex.solomon.dumper.SolomonShardOptsProviderImpl;
import ru.yandex.solomon.dumper.www.DumperLocalShardsWww;
import ru.yandex.solomon.dumper.www.DumperObjectFinder;
import ru.yandex.solomon.dumper.www.SolomonShardMetricsController;
import ru.yandex.solomon.flags.FeatureFlagHolderStub;
import ru.yandex.solomon.flags.FeatureFlagsHolder;

/**
 * @author Vladimir Gordiychuk
 */
@Import({
    KvContext.class,
    LongTermStorageContext.class,
    DumperLocalShardsWww.class,
    DumperObjectFinder.class,
    ConfigDaoContext.class,
})
@Configuration
public class DumperContext {

    @Bean
    public FeatureFlagsHolder featureFlagsHolder() {
        return new FeatureFlagHolderStub();
    }

    @Bean
    public DumperLocalShards localShards() {
        return new DumperLocalShards();
    }

    @Bean
    public DumperShardMetricsAggregated shardMetricsAggregated() {
        return new DumperShardMetricsAggregated();
    }

    @Bean
    public DumperShardMetricSupplier shardMetrics(DumperLocalShards shards) {
        return new DumperShardMetricSupplier(shards);
    }

    @Bean
    public SolomonShardOptsProviderImpl optsProvider(ShardsDao dao, ThreadPoolProvider threads) {
        var executor = threads.getExecutorService("CpuLowPriority", "ThreadPools");
        var timer = threads.getSchedulerExecutorService();
        return new SolomonShardOptsProviderImpl(dao, timer, executor);
    }

    @Bean
    public SolomonShardMetricsController solomonShardMetricsController(DumperLocalShards shards) {
        return new SolomonShardMetricsController(shards);
    }
}
