package ru.yandex.solomon.dumper.storage.shortterm;

import io.netty.buffer.ByteBuf;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Vladimir Gordiychuk
 */
public class DumperFile implements MemMeasurable {
    public final DumperTx tx;
    public final ByteBuf content;

    public DumperFile(DumperTx tx, ByteBuf content) {
        this.tx = tx;
        this.content = content;
    }

    public void release() {
        content.release();
    }

    @Override
    public String toString() {
        return "DumperFile{" +
            "tx=" + tx +
            ", content=" + DataSize.shortString(content.readableBytes()) +
            '}';
    }

    @Override
    public long memorySizeIncludingSelf() {
        return MemoryCounter.byteBufSize(content);
    }
}
