package ru.yandex.solomon.dumper.storage.shortterm;

import java.time.Instant;


/**
 * @author Vladimir Gordiychuk
 */
public class DumperTx implements Comparable<DumperTx> {
    public final int clusterId;
    public final int shardId;
    public final long txn;
    public final long createdAtSec;

    public DumperTx(int clusterId, int shardId, long txn, long createdAtSec) {
        this.clusterId = clusterId;
        this.shardId = shardId;
        this.txn = txn;
        this.createdAtSec = createdAtSec;
    }

    public int getShardId() {
        return shardId;
    }

    public long getTxn() {
        return txn;
    }

    public long getCreatedAtSec() {
        return createdAtSec;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DumperTx)) return false;

        DumperTx tx = (DumperTx) o;

        if (shardId != tx.shardId) return false;
        return txn == tx.txn;
    }

    @Override
    public int hashCode() {
        int result = shardId;
        result = 31 * result + (int) (txn ^ (txn >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "DumperTxn{" +
            "clusterId=" + clusterId +
            ", shardId=" + shardId +
            ", txn=" + txn +
            ", createdAt=" + Instant.ofEpochSecond(createdAtSec) +
            '}';
    }

    @Override
    public int compareTo(DumperTx o) {
        int cmp = Integer.compare(shardId, o.shardId);
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(txn, o.txn);
    }
}
