package ru.yandex.solomon.dumper.storage.shortterm;

import javax.annotation.Nullable;

import ru.yandex.kikimr.client.kv.KikimrKvGenerationChangedCheckedException;
import ru.yandex.kikimr.client.kv.KikimrKvGenerationChangedRuntimeException;

/**
 * @author Vladimir Gordiychuk
 */
public class KvExceptionHandler {
    public static boolean isGenerationChanged(@Nullable Throwable e) {
        Throwable cause = e;
        while (cause != null) {
            if (cause instanceof KikimrKvGenerationChangedRuntimeException) {
                return true;
            } else if (cause instanceof KikimrKvGenerationChangedCheckedException) {
                return true;
            }

            cause = cause.getCause();
        }
        return false;
    }
}
