package ru.yandex.solomon.dumper.storage.shortterm;

/**
 * @author Vladimir Gordiychuk
 */
public class ProducerKey {

    public static void validateClusterId(int clusterId) {
        if (clusterId < 0) {
            throw new IllegalArgumentException("ClusterId can't be negative: " + clusterId);
        }
        if (clusterId >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("ClusterId " + clusterId + " >= max " + Short.MAX_VALUE);
        }
    }

    public static void validateShardId(int shardId) {
        if (shardId < 0) {
            throw new IllegalArgumentException("ShardId can't be negative: " + shardId);
        }
        if (shardId >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("ShardId " + shardId + " >= max " + Short.MAX_VALUE);
        }
    }

    public static int makeProducerId(int clusterId, int shardId) {
        validateClusterId(clusterId);
        validateShardId(shardId);
        int result = clusterId << 16;
        result |= shardId;
        return result;
    }

    public static int makeProducerId(DumperTx tx) {
        return makeProducerId(tx.clusterId, tx.shardId);
    }

    public static int clusterId(int producerId) {
        return (int) (producerId >> 16);
    }

    public static int shardId(int producerId) {
        return producerId & 0x0000ffff;
    }
}
