package ru.yandex.solomon.dumper.storage.shortterm.file;

import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Vladimir Gordiychuk
 */
public class CompositeFileNameCollector implements FileNameCollector<FileName> {
    private EnumMap<FileType, FileNameCollector<FileName>> byFileType = new EnumMap<>(FileType.class);

    @Override
    public boolean append(String name, int bytesSize, long createdAt) {
        for (var type : FileType.values()) {
            if (!name.startsWith(type.getPrefix())) {
                continue;
            }
            var collector = byFileType.get(type);
            if (collector == null) {
                collector = type.newCollector();
                byFileType.put(type, collector);
            }
            String nameWithoutKind = name.substring(type.getPrefix().length());
            if (collector.append(nameWithoutKind, bytesSize, createdAt)) {
                return true;
            }
        }

        return false;
    }

    @Override
    public List<FileName> complete() {
        return byFileType.values()
            .stream()
            .filter(Objects::nonNull)
            .flatMap(fileCollector -> fileCollector.complete().stream())
            .collect(Collectors.toList());
    }
}
