package ru.yandex.solomon.dumper.storage.shortterm.file;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Vladimir Gordiychuk
 */
public class DumperLogFileNameCollector implements FileNameCollector<DumperLogFileName> {
    private final List<DumperLogFileName> result = new ArrayList<>();

    private String txn;
    private int chunkNo;
    private boolean last;
    private boolean valid;

    private long createdAt;
    private int bytesSize;

    public DumperLogFileNameCollector() {
        clean();
    }

    @Override
    public boolean append(String name, int bytesSize, long createdAt) {
        var matcher = DumperLogFileName.PATTERN.matcher(name);
        if (!matcher.matches()) {
            return false;
        }

        String txn = matcher.group(1);
        int chunkNo = Integer.parseInt(matcher.group(2));
        boolean last = "z".equals(matcher.group(3));

        if (!txn.equals(this.txn) || this.last) {
            flush();
            this.txn = txn;
        }

        if (this.chunkNo + 1 != chunkNo) {
            valid = false;
        }
        this.chunkNo = chunkNo;
        this.bytesSize += bytesSize;
        this.createdAt = Math.max(this.createdAt, createdAt);
        this.last = last;
        return true;
    }

    private void flush() {
        if (chunkNo == -1) {
            return;
        }

        try {
            long txn = Long.parseLong(this.txn);
            valid &= last;
            result.add(new DumperLogFileName(txn, chunkNo + 1, bytesSize, createdAt, valid));
        } finally {
            clean();
        }
    }

    private void clean() {
        chunkNo = -1;
        txn = "";
        valid = true;
        createdAt = 0;
        bytesSize = 0;
    }

    @Override
    public List<DumperLogFileName> complete() {
        flush();
        return result;
    }
}
