package ru.yandex.solomon.dumper.storage.shortterm.file;

/**
 * @author Vladimir Gordiychuk
 */
public abstract class FileName {
    private final int fileCount;
    private final int bytesSize;
    private final long createdAt;
    private final boolean valid;

    public FileName(int fileCount, int bytesSize, long createdAt, boolean valid) {
        this.fileCount = fileCount;
        this.bytesSize = bytesSize;
        this.createdAt = createdAt;
        this.valid = valid;
    }

    public int getFileCount() {
        return fileCount;
    }

    public int getBytesSize() {
        return bytesSize;
    }

    public long getCreatedAt() {
        return createdAt;
    }

    public boolean isValid() {
        return valid;
    }

    public abstract FileType getType();

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FileName fileName = (FileName) o;

        if (fileCount != fileName.fileCount) return false;
        if (bytesSize != fileName.bytesSize) return false;
        if (createdAt != fileName.createdAt) return false;
        return valid == fileName.valid;
    }

    @Override
    public int hashCode() {
        int result = fileCount;
        result = 31 * result + bytesSize;
        result = 31 * result + (int) (createdAt ^ (createdAt >>> 32));
        result = 31 * result + (valid ? 1 : 0);
        return result;
    }
}
