package ru.yandex.solomon.dumper.storage.shortterm.file;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Vladimir Gordiychuk
 */
public class FileNamesList {
    private final List<FileName> list;
    private final Map<FileType, List<FileName>> byType;

    public FileNamesList(List<FileName> files) {
        this.list = files;
        this.byType = files.stream().collect(Collectors.groupingBy(FileName::getType));
    }

    @SuppressWarnings("unchecked")
    public <T extends FileName> List<T> list() {
        return (List<T>) list;
    }

    @SuppressWarnings("unchecked")
    public <T extends FileName> List<T> list(FileType type) {
        return (List<T>) byType.getOrDefault(type, List.of());
    }

    @Override
    public String toString() {
        return list.toString();
    }
}
