package ru.yandex.solomon.dumper.storage.shortterm.file;

import java.util.function.Function;

/**
 * @author Vladimir Gordiychuk
 */
public enum FileType {
    MEMSTORE_SNAPSHOT("m.s.", (ignore) -> new MemstoreSnapshotFileNameCollector()),
    DUMPER_LOG("d.l.", (ignore) -> new DumperLogFileNameCollector()),
    DUMPER_LATEST_TXN("d.txn.last", SingleFileNameCollector::new);

    private final String prefix;
    private final Function<FileType, FileNameCollector<? extends FileName>> collectorFunction;

    FileType(String prefix, Function<FileType, FileNameCollector<? extends FileName>> collectorFunction) {
        this.prefix = prefix;
        this.collectorFunction = collectorFunction;
    }

    public String getPrefix() {
        return prefix;
    }

    @SuppressWarnings("unchecked")
    public <T extends FileName> FileNameCollector<T> newCollector() {
        return (FileNameCollector<T>) collectorFunction.apply(this);
    }
}
