package ru.yandex.solomon.dumper.storage.shortterm.file;

import java.time.Instant;

import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Vladimir Gordiychuk
 */
public class MemstoreSnapshotFileName extends FileName {
    private final int nodeId;
    private final long txn;

    public MemstoreSnapshotFileName(int nodeId, long txn, int fileCount, int bytesSize, long createdAt, boolean valid) {
        super(fileCount, bytesSize, createdAt, valid);
        this.nodeId = nodeId;
        this.txn = txn;
    }

    public MemstoreTxn getTxn() {
        return new MemstoreTxn(nodeId, txn);
    }

    @Override
    public FileType getType() {
        return FileType.MEMSTORE_SNAPSHOT;
    }

    public static String format(MemstoreTxn txn, int chunkNo, boolean last) {
        return format(txn.getNodeId(), txn.getTxn(), chunkNo, last);
    }

    public static String format(int nodeId, long txn) {
        return String.format("%s%03d.%017d", FileType.MEMSTORE_SNAPSHOT.getPrefix(), nodeId, txn);
    }

    public static String format(int nodeId, long txn, int chunkNo, boolean last) {
        return String.format("%s%03d.%017d.%06d%s", FileType.MEMSTORE_SNAPSHOT.getPrefix(), nodeId, txn, chunkNo, last ? 'z' : "y");
    }

    public String format(int chunkNo) {
        return format(nodeId, txn, chunkNo, chunkNo + 1 == getFileCount());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MemstoreSnapshotFileName)) return false;
        if (!super.equals(o)) return false;

        MemstoreSnapshotFileName that = (MemstoreSnapshotFileName) o;

        if (nodeId != that.nodeId) return false;
        return txn == that.txn;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + nodeId;
        result = 31 * result + (int) (txn ^ (txn >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "MemstoreLogFile{" +
            "nodeId=" + nodeId +
            ", txn=" + txn +
            ", fileCount=" + getFileCount() +
            ", bytesSize=" + DataSize.shortString(getBytesSize()) +
            ", createdAt=" + Instant.ofEpochSecond(getCreatedAt()) +
            ", valid=" + isValid() +
            '}';
    }
}
