package ru.yandex.solomon.dumper.storage.shortterm.file;

/**
 * @author Vladimir Gordiychuk
 */
public class MemstoreTxn {
    private final int nodeId;
    private final long txn;

    public MemstoreTxn(int nodeId, long txn) {
        this.nodeId = nodeId;
        this.txn = txn;
    }

    public int getNodeId() {
        return nodeId;
    }

    public long getTxn() {
        return txn;
    }

    public String format() {
        return String.format("%03d.%017d", nodeId, txn);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MemstoreTxn that = (MemstoreTxn) o;

        if (nodeId != that.nodeId) return false;
        return txn == that.txn;
    }

    @Override
    public int hashCode() {
        int result = nodeId;
        result = 31 * result + (int) (txn ^ (txn >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return format().replace(".", "/");
    }
}
