package ru.yandex.solomon.dumper.storage.shortterm.file;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Vladimir Gordiychuk
 */
public class SingleFileNameCollector implements FileNameCollector<SingleFileName> {
    private final FileType type;
    private final List<SingleFileName> result = new ArrayList<>();

    public SingleFileNameCollector(FileType type) {
        this.type = type;
    }

    @Override
    public boolean append(String name, int bytesSize, long createdAt) {
        return result.add(new SingleFileName(type, 1, bytesSize, createdAt, true));
    }

    @Override
    public List<SingleFileName> complete() {
        return result;
    }
}
