package ru.yandex.solomon.dumper.www;

import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.dumper.DumperLocalShards;
import ru.yandex.solomon.dumper.SolomonShardMetricsSupplier;
import ru.yandex.solomon.selfmon.mon.HttpMetricRegistryEncoder;

/**
 * @author Vladimir Gordiychuk
 */
@RestController
public class SolomonShardMetricsController {
    private final SolomonShardMetricsSupplier supplier;

    public SolomonShardMetricsController(DumperLocalShards localShards) {
        this.supplier = new SolomonShardMetricsSupplier(localShards);
    }

    @RequestMapping({ "/solomon-shard-metrics" })
    public ResponseEntity<byte[]> metrics(ServerHttpRequest request) {
        return HttpMetricRegistryEncoder.encode(supplier, request);
    }
}
