package ru.yandex.solomon.dumper;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.ut.ManualClock;
import ru.yandex.solomon.ut.ManualScheduledExecutorService;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class ConcurrentMetricsCacheTest {

    private ConcurrentMetricsCache cache;
    private ManualClock clock;
    private ScheduledExecutorService timer;

    @Before
    public void setUp() {
        clock = new ManualClock();
        timer = new ManualScheduledExecutorService(2, clock);
        cache = new ConcurrentMetricsCache(ForkJoinPool.commonPool(), timer, clock, new MetricsCacheMetrics(new MetricRegistry()));
    }

    @After
    public void tearDown() {
        timer.shutdownNow();
    }

    @Test
    public void resolve() {
        assertNull(cache.resolve(Labels.of("name", "alice")));
        var expected = new MetricImpl(42, 1111L, MetricType.DGAUGE);
        cache.add(Map.of(Labels.of("name", "alice"), expected));
        var actual = cache.resolve(Labels.of("name", "alice"));
        assertEquals(expected, actual);
        assertNull(cache.resolve(Labels.of("name", "bob")));
    }

    @Test
    public void settlers() {
        assertFalse(cache.containsInSettlers(Labels.of("name", "alice")));
        assertFalse(cache.containsInSettlers(Labels.of("name", "bob")));

        cache.addSettlers(List.of(Labels.of("name", "alice")));

        assertTrue(cache.containsInSettlers(Labels.of("name", "alice")));
        assertFalse(cache.containsInSettlers(Labels.of("name", "bob")));
    }

    @Test
    public void resetSettlers() {
        Labels labels = Labels.of("name", "alice");
        assertFalse(cache.containsInSettlers(labels));

        cache.addSettlers(List.of(labels));
        assertTrue(cache.containsInSettlers(labels));

        cache.resetSettlers();
        assertFalse(cache.containsInSettlers(labels));
    }
}
