package ru.yandex.solomon.dumper;

import java.util.concurrent.ThreadLocalRandom;

import io.netty.buffer.ByteBufAllocator;

import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.model.protobuf.MetricTypeConverter;
import ru.yandex.solomon.slog.Log;
import ru.yandex.solomon.slog.SnapshotLogDataBuilder;
import ru.yandex.solomon.slog.SnapshotLogDataBuilderImpl;
import ru.yandex.solomon.slog.UnresolvedLogMetaBuilder;
import ru.yandex.solomon.slog.UnresolvedLogMetaBuilderImpl;

/**
 * @author Vladimir Gordiychuk
 */
public class MemstoreSnapshotBuilder implements AutoCloseable {
    private int numId;
    private final UnresolvedLogMetaBuilder metaBuilder;
    private final SnapshotLogDataBuilder dataBuilder;

    public MemstoreSnapshotBuilder(ByteBufAllocator allocator) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.numId = random.nextInt();
        numId = random.nextInt();
        var compressionAlg = CompressionAlg.values()[random.nextInt(CompressionAlg.values().length)];
        metaBuilder = new UnresolvedLogMetaBuilderImpl(numId, compressionAlg, allocator);
        dataBuilder = new SnapshotLogDataBuilderImpl(compressionAlg, numId, allocator);
    }

    public int getNumId() {
        return numId;
    }

    public void commonLabels(Labels labels) {
        metaBuilder.onCommonLabels(labels);
    }

    public void add(Labels labels, MetricArchiveMutable archive) {
        var type = MetricTypeConverter.fromProto(archive.getType());
        int size = dataBuilder.onTimeSeries(archive.toImmutableNoCopy());
        metaBuilder.onMetric(type, labels, archive.getRecordCount(), size);
    }

    public Log build() {
        return new Log(numId, metaBuilder.build(), dataBuilder.build());
    }

    @Override
    public void close() {
        metaBuilder.close();
        dataBuilder.close();
    }
}
