package ru.yandex.solomon.dumper;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsCacheStub implements MetricsCache {
    private static final Object DUMMY = new Object();
    private final ConcurrentMap<Labels, Metric> cache = new ConcurrentHashMap<>();
    private final ConcurrentMap<Labels, Object> settlers = new ConcurrentHashMap();

    public void add(MetricType type, Labels labels, int shardId, long localId) {
        cache.put(labels, new MetricImpl(shardId, localId, type));
    }

    public void addSettler(Labels labels) {
        settlers.put(labels, DUMMY);
    }

    @Nullable
    @Override
    public Metric resolve(Labels labels) {
        return cache.get(labels);
    }

    @Override
    public boolean containsInSettlers(Labels labels) {
        return settlers.containsKey(labels);
    }

    @Override
    public long memorySizeIncludingSelf() {
        return 0;
    }
}
