package ru.yandex.solomon.dumper;

import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

import javax.annotation.Nullable;

import com.google.common.collect.Sets;

import ru.yandex.stockpile.api.EDecimPolicy;

/**
 * @author Vladimir Gordiychuk
 */
public class SolomonShardOptsProviderStub implements SolomonShardOptsProvider {
    private Set<Integer> removedShards = Sets.newConcurrentHashSet();
    private Set<Integer> createdShards = Sets.newConcurrentHashSet();
    private AtomicInteger seqNo = new AtomicInteger(ThreadLocalRandom.current().nextInt());

    @Override
    public boolean isInitialized() {
        return true;
    }

    public void removeShard(int numId) {
        removedShards.add(numId);
        createdShards.remove(numId);
        seqNo.incrementAndGet();
    }

    public void addShard(int numId) {
        removedShards.remove(numId);
        seqNo.incrementAndGet();
    }

    @Nullable
    @Override
    public SolomonShardOpts resolve(int numId) {
        if (removedShards.contains(numId)) {
            return null;
        }

        if (createdShards.add(numId)) {
            seqNo.incrementAndGet();
        }

        return SolomonShardOpts.newBuilder()
                .withDecimPolicy(EDecimPolicy.POLICY_5_MIN_AFTER_7_DAYS)
                .withNumId(numId)
                .withId("id-for-" + Integer.toUnsignedString(numId))
                .withProjectId("projectId-for-" + Integer.toUnsignedString(numId))
                .build();
    }

    @Override
    public SolomonShardOptsProvider snapshot() {
        return this;
    }

    @Override
    public long optionsHash() {
        return seqNo.get();
    }
}
