package ru.yandex.solomon.dumper.storage.shortterm;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.kikimr.client.kv.inMem.KikimrKvClientInMem;
import ru.yandex.solomon.dumper.DumperShardId;
import ru.yandex.solomon.ut.ManualClock;
import ru.yandex.solomon.ut.ManualScheduledExecutorService;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class KvTabletsMappingTest {

    private KikimrKvClientInMem kvClient;
    private KvTabletsMapping mapping;
    private ManualClock clock;
    private ManualScheduledExecutorService timer;

    @Before
    public void setUp() {
        kvClient = new KikimrKvClientInMem();
        clock = new ManualClock();
        timer = new ManualScheduledExecutorService(2, clock);
        mapping = new KvTabletsMapping("/test/ShortTermStorage/KV", kvClient, timer, timer);
    }

    @After
    public void tearDown() {
        timer.shutdownNow();
    }

    @Test
    public void resolve() {
        mapping.getReadyFuture().join();
        LongOpenHashSet unique = new LongOpenHashSet();
        DumperShardId.idStream().forEach(shardId -> {
            long tabletId = mapping.getTabletId(shardId);
            assertTrue(unique.add(tabletId));
        });
        assertEquals(DumperShardId.SHARD_COUNT, unique.size());
    }
}
