package ru.yandex.solomon.dumper.storage.shortterm;

import java.util.concurrent.ThreadLocalRandom;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

/**
 * @author Vladimir Gordiychuk
 */
public class ProducerKeyTest {

    @Test
    public void makeId() {
        int clusterId = ThreadLocalRandom.current().nextInt(0, Short.MAX_VALUE);
        int shardId = ThreadLocalRandom.current().nextInt(1, Short.MAX_VALUE);

        int producerId = ProducerKey.makeProducerId(clusterId, shardId);
        assertEquals(clusterId, ProducerKey.clusterId(producerId));
        assertEquals(shardId, ProducerKey.shardId(producerId));
    }

    @Test
    public void noProducerIdCollision() {
        IntOpenHashSet ids = new IntOpenHashSet();
        for (int clusterId = 1; clusterId < 100; clusterId++) {
            for (int shardId = 1; shardId < 10_000; shardId++) {
                var producerId = ProducerKey.makeProducerId(clusterId, shardId);
                assertFalse("not unique: " + producerId, ids.contains(producerId));
                ids.add(producerId);
            }
        }
    }
}
