package ru.yandex.solomon.dumper.storage.shortterm.file;

import java.util.List;

import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;


/**
 * @author Vladimir Gordiychuk
 */
public class CompositeFileNameCollectorTest {
    private CompositeFileNameCollector collector;

    @Before
    public void setUp() {
        collector = new CompositeFileNameCollector();
    }

    @Test
    public void notValid() {
        assertFalse(collector.append("not_valid_file_name", 123, 42));
        assertEquals(List.of(), collector.complete());
    }

    @Test
    public void memstoreLogs() {
        long createdAt = System.currentTimeMillis() - 15_000;
        assertTrue(collector.append(MemstoreSnapshotFileName.format(1, 42, 0, false), 10, createdAt));
        assertTrue(collector.append(MemstoreSnapshotFileName.format(1, 42, 1, true), 20, createdAt + 1));
        assertTrue(collector.append(MemstoreSnapshotFileName.format(1, 43, 0, true), 15, createdAt + 1));
        assertTrue(collector.append(MemstoreSnapshotFileName.format(1, 44, 10, false), 128, createdAt + 2));
        assertTrue(collector.append(MemstoreSnapshotFileName.format(1, 45, 0, false), 128, createdAt + 3));
        assertTrue(collector.append(MemstoreSnapshotFileName.format(2, 45, 1, true), 128, createdAt + 4));

        var expected = List.of(
            new MemstoreSnapshotFileName(1, 42, 2, 30, createdAt, true),
            new MemstoreSnapshotFileName(1, 43, 1, 15, createdAt + 1, true),
            new MemstoreSnapshotFileName(1, 44, 11, 128, createdAt + 2, false),
            new MemstoreSnapshotFileName(1, 45, 1, 128, createdAt + 3, false),
            new MemstoreSnapshotFileName(2, 45, 2, 128, createdAt + 4, false)
        );

        assertArrayEquals(expected.toArray(), collector.complete().toArray());
    }

    @Test
    public void dumperLogs() {
        long createdAt = System.currentTimeMillis() - 15_000;
        assertTrue(collector.append(DumperLogFileName.format(42, 0, false), 10, createdAt));
        assertTrue(collector.append(DumperLogFileName.format(42, 1, true), 20, createdAt));
        assertTrue(collector.append(DumperLogFileName.format(43, 0, true), 15, createdAt + 1));
        assertTrue(collector.append(DumperLogFileName.format(44, 10, true), 128, createdAt + 2));

        var expected = List.of(
            new DumperLogFileName(42, 2, 30, createdAt, true),
            new DumperLogFileName(43, 1, 15, createdAt + 1, true),
            new DumperLogFileName(44, 11, 128, createdAt + 2, false)
        );

        assertArrayEquals(expected.toArray(), collector.complete().toArray());
    }
}
