#include "agent_cleaner.h"

#include <solomon/libs/cpp/logging/logging.h>

#include <library/cpp/actors/core/actor_bootstrapped.h>
#include <library/cpp/actors/core/hfunc.h>
#include <library/cpp/actors/core/log.h>

#include <util/random/random.h>

using namespace NActors;

namespace NSolomon::NFetcher {
namespace {
    class TAgentCleanerActor: public TActorBootstrapped<TAgentCleanerActor> {
    public:
        TAgentCleanerActor(NDb::IAgentConfigDaoPtr dao, TDuration interval, TDuration maxAge)
            : Dao_{std::move(dao)}
            , Interval_{interval}
            , MaxAge_{maxAge}
        {
        }

        void Bootstrap() {
            Become(&TThis::StateWork);
            PingSelf();
        }

        STATEFN(StateWork) {
            switch (ev->GetTypeRewrite()) {
                cFunc(TEvents::TEvWakeup::EventType, OnWakeup);
                cFunc(TEvents::TEvPoisonPill::EventType, PassAway);
            }
        }

    private:
        void OnWakeup() {
            auto* as = TActorContext::ActorSystem();
            Dao_->DeleteObsolete(TInstant::Now() - MaxAge_).Subscribe([=] (auto f) {
                try {
                    f.GetValue();
                    MON_INFO_C(*as, AgentCleaner, "Agent cleanup successfully completed");
                } catch (...) {
                    MON_INFO_C(*as, AgentCleaner, "Agent cleanup failed: " << CurrentExceptionMessage());
                }
            });

            PingSelf();
        }

        void PingSelf() {
            const auto jitter = TDuration::Seconds(RandomNumber<ui32>(Interval_.Seconds() * 0.2));
            Schedule(Interval_ + jitter, new TEvents::TEvWakeup);
        }

    private:
        NDb::IAgentConfigDaoPtr Dao_;
        TDuration Interval_;
        TDuration MaxAge_;
    };
} // namespace
    NActors::IActor* CreateAgentCleanerActor(NDb::IAgentConfigDaoPtr dao, TDuration interval, TDuration maxAge) {
        return new TAgentCleanerActor{std::move(dao), interval, maxAge};
    }
} // namespace NSolomon
