#pragma once

#include <solomon/services/fetcher/lib/cluster/cluster.h>
#include <solomon/services/fetcher/lib/data_sink/processing_client.h>

#include <solomon/services/fetcher/config/fetcher_config.pb.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>

#include <util/generic/vector.h>

namespace NSolomon::NFetcher {
    struct INodeMapper {
        virtual ~INodeMapper() = default;
        virtual ui32 GetId(TStringBuf hostname) const = 0;
    };

    class TFetcherCluster: public TClusterMapBase {
    public:
        TFetcherCluster();
        ~TFetcherCluster();
        TFetcherCluster(TClusterMapBase o);

        static TIntrusivePtr<TFetcherCluster> FromString(TStringBuf data);

        TString Dump() const;

        // <host>:<port>
        const TVector<TString>& Endpoints() const;

    private:
        using TClusterMapBase::Load;
        TVector<TString> Endpoints_;
    };

    THashMap<TClusterNode, NActors::TActorId> CreateRpcSinks(
        TActorRuntime& runtime,
        std::shared_ptr<NMonitoring::IMetricRegistry> metrics,
        std::shared_ptr<NMonitoring::IMetricRegistry> shardMetrics,
        const THashSet<TClusterNode>& locations,
        IProcessingClusterClientPtr clusterClient,
        i64 localMemLimit,
        size_t executorPool);

    EOperationMode OperationModeFromProto(TFetcherConfig::EOperationMode proto);
} // namespace NSolomon::NFetcher
