#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>
#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>
#include <solomon/services/fetcher/lib/host_groups/host_and_labels.h>

#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/threading/future/future.h>

#include <util/generic/ptr.h>

namespace NSolomon::NFetcher {
    struct TClusterResolveResponse {
        struct TGroupInfo {
            TErrorOr<TVector<THostAndLabels>, TGenericError> Result;
            TString Name;
        };

        TVector<TGroupInfo> Groups;
    };

    struct TClusterResolveRequest {
        enum class EGroupType {
            ConductorGroup = 1,
            ConductorTag = 2,
            Nanny = 3,
            Yp = 4,
            Qloud = 5,
            Network = 6,
            InstanceGroup = 7,
            Host = 8,
            HostUrl = 9,
        };

        struct TGroupConf {
            EGroupType Type;
            TString JsonConfig;
        };

        TVector<TGroupConf> Groups;
    };

    using TAsyncResolveClusterResponse = NThreading::TFuture<TErrorOr<TClusterResolveResponse, NSolomon::TApiCallError>>;
    class IFetcherClient {
    public:
        virtual ~IFetcherClient() = default;
        virtual TAsyncResolveClusterResponse ResolveCluster(TClusterResolveRequest req) = 0;
    };

    using IFetcherClientPtr = THolder<IFetcherClient>;

    IFetcherClientPtr CreateGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf, NMonitoring::IMetricRegistry& registry, TString clientId = {});

} // namespace NSolomon::NFetcher
