#include "auth_token.h"

#include <solomon/libs/cpp/http/client/http.h>

#include <library/cpp/http/misc/http_headers.h>

#include <util/string/builder.h>
#include <util/string/split.h>

namespace NSolomon::NFetcher {

TErrorOr<TAuthToken, TGenericError> ParseAuthToken(TStringBuf authHeader) {
    EAuthType authType{};
    TStringBuf authToken;

    auto splitObj = StringSplitter(authHeader)
            .SplitBySet(TStringBuf(" \t").data())
            .SkipEmpty();

    size_t partsCnt = 0;
    for (TStringBuf headerPart: splitObj) {
        ++partsCnt;

        if (partsCnt == 1) {
            TStringBuf authTypeStr = headerPart;

            if (authTypeStr == TStringBuf("OAuth")) {
                authType = EAuthType::OAuth;
            } else if (authTypeStr == TStringBuf("X-Ya-Service-Ticket")) {
                authType = EAuthType::TVM;
            } else if (authTypeStr == TStringBuf("Bearer")) {
                authType = EAuthType::IAM;
            } else {
                TString msg = TStringBuilder() << "wrong auth type: \"" << authTypeStr << "\"";
                return TGenericError{std::move(msg)};
            }
        } else if (partsCnt == 2) {
            authToken = headerPart;
        } else {
            break;
        }
    }

    if (partsCnt != 2) {
        return TGenericError{"incorrect Authorization header format"};
    }

    return TAuthToken{
        .Type = authType,
        .Token = TString{authToken},
    };
}

TErrorOr<TAuthToken, TGenericError> ParseAuthToken(const IHeaders& headers) {
    if (auto authToken = headers.Find(NHttpHeaders::AUTHORIZATION)) {
        return ParseAuthToken(*authToken);
    }
    return TGenericError("no authorization header");
}

} // namespace NSolomon::NFetcher
