#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>

namespace NSolomon {
struct IHeaders;
} // namespace NSolomon

namespace NSolomon::NFetcher {

enum class EAuthType {
    NoAuth = 0,
    OAuth,
    IAM,
    TVM,
};

struct TAuthToken {
    EAuthType Type;
    TString Token;
};

TErrorOr<TAuthToken, TGenericError> ParseAuthToken(TStringBuf authHeader);

TErrorOr<TAuthToken, TGenericError> ParseAuthToken(const IHeaders& headers);

} // namespace NSolomon::NFetcher
