#include <solomon/services/fetcher/lib/auth/auth_token.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NFetcher;

TEST(TAuthTokenTest, ParseOauthToken) {
    std::vector<TStringBuf> authHeaders{
        TStringBuf{"OAuth abc-1234-xyz"},
        TStringBuf{"OAuth  abc-1234-xyz"},
        TStringBuf{"OAuth  abc-1234-xyz "},
        TStringBuf{"OAuth\tabc-1234-xyz "},
        TStringBuf{"OAuth\tabc-1234-xyz\t"},
        TStringBuf{"OAuth abc-1234-xyz\t"},
    };

    for (auto authHeader: authHeaders) {
        auto token = ParseAuthToken(authHeader);
        ASSERT_TRUE(token.Success()) << token.Error().Message() << ", authHeader=" << authHeader;
        ASSERT_EQ(token.Value().Type, EAuthType::OAuth) << "authHeader=" << authHeader;
        ASSERT_EQ(token.Value().Token, "abc-1234-xyz") << "authHeader=" << authHeader;
    }
}

TEST(TAuthTokenTest, ParseIamToken) {
    std::vector<TStringBuf> authHeaders{
        TStringBuf{"Bearer abc-1234-xyz"},
        TStringBuf{"Bearer  abc-1234-xyz"},
        TStringBuf{"Bearer  abc-1234-xyz "},
        TStringBuf{"Bearer\tabc-1234-xyz "},
        TStringBuf{"Bearer\tabc-1234-xyz\t"},
        TStringBuf{"Bearer abc-1234-xyz\t"},
    };

    for (auto authHeader: authHeaders) {
        auto token = ParseAuthToken(authHeader);
        ASSERT_TRUE(token.Success()) << token.Error().Message() << ", authHeader=" << authHeader;
        ASSERT_EQ(token.Value().Type, EAuthType::IAM) << "authHeader=" << authHeader;
        ASSERT_EQ(token.Value().Token, "abc-1234-xyz") << "authHeader=" << authHeader;
    }
}

TEST(TAuthTokenTest, ParseTvmToken) {
    std::vector<TStringBuf> authHeaders{
        TStringBuf{"X-Ya-Service-Ticket abc-1234-xyz"},
        TStringBuf{"X-Ya-Service-Ticket  abc-1234-xyz"},
        TStringBuf{"X-Ya-Service-Ticket  abc-1234-xyz "},
        TStringBuf{"X-Ya-Service-Ticket\tabc-1234-xyz "},
        TStringBuf{"X-Ya-Service-Ticket\tabc-1234-xyz\t"},
        TStringBuf{"X-Ya-Service-Ticket abc-1234-xyz\t"},
    };

    for (auto authHeader: authHeaders) {
        auto token = ParseAuthToken(authHeader);
        ASSERT_TRUE(token.Success()) << token.Error().Message() << ", authHeader=" << authHeader;
        ASSERT_EQ(token.Value().Type, EAuthType::TVM) << "authHeader=" << authHeader;
        ASSERT_EQ(token.Value().Token, "abc-1234-xyz") << "authHeader=" << authHeader;
    }
}

TEST(TAuthTokenTest, EmptyHeader) {
    auto token = ParseAuthToken("");
    ASSERT_TRUE(token.Fail());
    ASSERT_EQ(token.Error().Message(), "incorrect Authorization header format");
}

TEST(TAuthTokenTest, InvalidHeader) {
    auto token = ParseAuthToken("OAuth abc 123");
    ASSERT_TRUE(token.Fail());
    ASSERT_EQ(token.Error().Message(), "incorrect Authorization header format");
}

TEST(TAuthTokenTest, InvalidHeader2) {
    auto token = ParseAuthToken("Bearer ");
    ASSERT_TRUE(token.Fail());
    ASSERT_EQ(token.Error().Message(), "incorrect Authorization header format");
}
