#pragma once

#include <solomon/services/fetcher/config/access_service_config.pb.h>
#include <solomon/services/fetcher/lib/events.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/cloud/access_service/access_service.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NFetcher {

enum class EFailureType {
    Internal,
    FailedAuth,
};

struct TAccessServiceEvents: private TEventSlot<EEventSpace::Fetcher, FS_THIRD_PARTY> {
    enum {
        Authenticate = SpaceBegin,
        AuthenticationFailure, // includes timeout and error
        AuthenticationSuccess,
        Authorize,
        AuthorizationFailure,
        AuthorizationSuccess,
        End
    };

    static_assert(End < SpaceEnd, "too many event types");

    struct TAuthenticate: NActors::TEventLocal<TAuthenticate, Authenticate> {
        TString IamToken;
    };

    struct TAuthenticationSuccess: NActors::TEventLocal<TAuthenticationSuccess, AuthenticationSuccess> {
        TString Token;
        TIamAccount Account;

        explicit TAuthenticationSuccess(TString token, TIamAccount&& account)
            : Token{std::move(token)}
            , Account(std::move(account))
        {}
    };

    struct TAuthenticationFailure: NActors::TEventLocal<TAuthenticationFailure, AuthenticationFailure> {
        EFailureType Type;
        TString Message;

        explicit TAuthenticationFailure(EFailureType type, TString msg = {})
            : Type{type}
            , Message{std::move(msg)}
        {}
    };

    struct TAuthorize: NActors::TEventLocal<TAuthorize, Authorize> {
        TString ServiceAccountId;
        TString FolderId;
    };

    struct TAuthorizationSuccess: NActors::TEventLocal<TAuthorizationSuccess, AuthorizationSuccess> {
        yandex::cloud::priv::servicecontrol::v1::AuthorizeResponse Response;
    };

    struct TAuthorizationFailure: NActors::TEventLocal<TAuthorizationFailure, AuthorizationFailure> {
        EFailureType Type;
        TString Message;

        explicit TAuthorizationFailure(EFailureType type, TString msg = {})
            : Type{type}
            , Message{std::move(msg)}
        {}
    };
};

/**
 * @return An actor wrapper of a gRPC AccessService client
 */
std::unique_ptr<NActors::IActor> CreateAccessServiceActor(
    IAccessServiceClientPtr accessServiceClient,
    NActors::TActorId scheduler,
    TAccessServiceConfig config,
    std::shared_ptr<NMonitoring::TMetricRegistry> registry);

} // namespace NSolomon::NFetcher
