#pragma once

#include <solomon/services/fetcher/lib/events.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/error_or/error_or.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NFetcher {
struct TConductorEvents: private TEventSlot<EEventSpace::Fetcher, FS_THIRD_PARTY> {
        enum EEv {
            EvResolveTag = SpaceBegin,
            EvResolveGroup,
            EvResponse,
            EvEnd,
        };
        static_assert(EvEnd < SpaceEnd, "too many event types");

        struct TEvResolveTag: NActors::TEventLocal<TEvResolveTag, EvResolveTag> {
            TEvResolveTag(TString tag)
                : Tag{std::move(tag)}
            {
            }

            TString Tag;
        };

        struct TEvResolveGroup: NActors::TEventLocal<TEvResolveGroup, EvResolveGroup> {
            TEvResolveGroup(TString tag)
                : Group{std::move(tag)}
            {
            }

            TString Group;
        };

        struct TEvResponse: NActors::TEventLocal<TEvResponse, EvResponse> {
            using TResult = TErrorOr<TVector<TString>, TGenericError>;

            TEvResponse(TResult result)
                : Hosts{std::move(result)}
            {
            }

            TResult Hosts;
        };
    };

    struct TConductorClientConf {
        NActors::TActorId HttpProxy;
        TDuration Timeout{TDuration::Max()};
        ui8 Retries{0};
        TDuration RetryBackoff;
        TString Address{"c.yandex-team.ru"};
    };

    NActors::IActor* CreateConductorClient(TConductorClientConf conf);
} // namespace NSolomon::NFetcher
