#pragma once

#include "opearation_mode.h"

#include <solomon/services/fetcher/lib/racktables/dc_matcher.h>
#include <solomon/libs/cpp/cluster_map/cluster.h>

#include <utility>

namespace NSolomon::NFetcher {
    class TClusterInfo {
    public:
        TClusterInfo() = default;
        explicit TClusterInfo(TString id, EOperationMode mode = EOperationMode::Global, EDc dc = EDc::UNKNOWN)
            : Id_{std::move(id)}
            , Mode_{mode}
            , Dc_{dc}
        {
            Y_ENSURE(mode == EOperationMode::Global || dc != EDc::UNKNOWN);
        }

        void SetCluster(IClusterMapPtr cluster) {
            Cluster_ = std::move(cluster);
        }

        const IClusterMap& Cluster() const {
            return *Cluster_;
        }

        const TString& Id() const {
            return Id_;
        }

        EDc Dc() const {
            return Dc_;
        }

        EOperationMode OperationMode() const {
            return Mode_;
        }

    private:
        TString Id_;
        EOperationMode Mode_;
        EDc Dc_;
        IClusterMapPtr Cluster_;
    };

} // namespace NSolomon::NFetcher
