#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>

#include <util/generic/ptr.h>

namespace NSolomon {

    struct TDecodeError {
        explicit TDecodeError(TString msg)
            : Message{std::move(msg)}
        {
        }

        TString Message;
    };

    struct ICodec {
        using TDecodeResult = TErrorOr<TString, TDecodeError>;

        virtual ~ICodec() = default;
        virtual TDecodeResult Decompress(TStringBuf in) noexcept = 0;

        // Returning 0 means decompressed data size is not known at this point
        virtual ui64 DecompressedSize(TStringBuf in) const noexcept = 0;
    };

    struct ICodecFactory {
        virtual ~ICodecFactory() = default;

        /**
         * @return nullptr if codec for the specified format is absent
         */
        virtual ICodec* Codec(TStringBuf format) const = 0;
    };

    ICodecFactory* CodecFactory();

} // namespace NSolomon
