#include <solomon/services/fetcher/lib/codec/codec.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>
#include <util/stream/zlib.h>

#include <array>

using namespace NSolomon;

TEST(TCodecFactoryTest, KnownCodecs) {
    auto* factory = CodecFactory();

    std::array knownNames{
        TStringBuf{"gzip"},
        TStringBuf{"deflate"},
        TStringBuf{"br"},
        TStringBuf{"zlib"},
        TStringBuf{"snappy"},
        TStringBuf{"lz4"},
        TStringBuf{"lzma"},
        TStringBuf{"bzip2"},
    };

    for (auto& name: knownNames) {
        auto* codec = factory->Codec(name);
        ASSERT_TRUE(codec) << "name=" << name;
    }
}

void TestEncodeDecode(ZLib::StreamType streamType, TStringBuf codecName) {
    TBufferOutput bufferOut;
    {
        TZLibCompress zlib{&bufferOut, streamType};
        zlib.Write("Lorem ipsum dolor sit amet, ");
        zlib.Write("consectetur adipiscing elit, sed do eiusmod ");
        zlib.Write("tempor incididunt ut labore et dolore magna aliqua.");
    }

    auto* factory = CodecFactory();
    auto* codec = factory->Codec(codecName);

    auto& buffer = bufferOut.Buffer();
    auto result = codec->Decompress(TStringBuf{buffer.Data(), buffer.Size()});

    ASSERT_FALSE(result.Fail());
    ASSERT_EQ(result.Value(),
              "Lorem ipsum dolor sit amet, "
              "consectetur adipiscing elit, sed do eiusmod "
              "tempor incididunt ut labore et dolore magna aliqua.");
}

TEST(TCodecTest, DecodeGzip) {
    TestEncodeDecode(ZLib::GZip, "gzip");
}

TEST(TCodecTest, DecodeDeflate) {
    TestEncodeDecode(ZLib::ZLib, "deflate");
}
