#include "config.h"

#include <solomon/libs/cpp/config/units.h>

#include <library/cpp/protobuf/util/pb_io.h>

#include <util/generic/hash_set.h>

namespace NSolomon::NFetcher {

TFetcherConfig ParseTextProto(const TString& filePath) {
    TFetcherConfig config;
    static EParseFromTextFormatOptions options; // no flags -- all bits set to 0
    try {
        ParseFromTextFormat(filePath, config, options);
    } catch (...) {
        // using options above, we should catch an error if a config has unknown fields
        throw TConfigParseException() << CurrentExceptionMessage() << Endl;
    }
    return config;
}

void Validate(const TFetcherConfig&) {
    // TODO: implement validation logic
}

} // namespace NSolomon::NFetcher
