#include <solomon/services/fetcher/lib/config/config.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <util/system/tempfile.h>

using namespace NSolomon::NFetcher;

namespace {

void ValidateResource(TStringBuf name) {
    TString configText = NResource::Find(name);
    ASSERT_FALSE(configText.Empty()) << "cannot find resource " << name;

    TTempFileHandle tmp;
    tmp.Write(configText.data(), configText.size());
    tmp.FlushData();

    TFetcherConfig config;
    ASSERT_NO_THROW({ config = ParseTextProto(tmp.Name()); }) << "cannot parse config " << name;
    ASSERT_NO_THROW({ Validate(config); }) << "non valid config " << name;
}

} // namespace

TEST(TConfigTest, CloudPreprod) {
    ValidateResource("cloud-preprod/fetcher.conf");
}

TEST(TConfigTest, CloudProd) {
    ValidateResource("cloud-prod/fetcher.sas.conf");
    ValidateResource("cloud-prod/fetcher.vla.conf");
}

TEST(TConfigTest, CloudIsrael) {
    ValidateResource("israel/fetcher.a.conf");
    ValidateResource("israel/fetcher.b.conf");
}

TEST(TConfigTest, Prestable) {
    ValidateResource("prestable/fetcher.conf");
    ValidateResource("prestable/fetcher.monitoring.conf");
}

TEST(TConfigTest, ProductionSts) {
    ValidateResource("production/fetcher.conf");
}

TEST(TConfigTest, Production) {
    ValidateResource("production/fetcher.sas.conf");
    ValidateResource("production/fetcher.vla.conf");
}

TEST(TConfigTest, Testing) {
    ValidateResource("testing/fetcher.conf");
}
