#pragma once

#include "diff.h"

#include <solomon/services/fetcher/lib/fetcher_shard.h>
#include <solomon/services/fetcher/lib/id.h>

#include <solomon/libs/cpp/conf_db/puller/puller.h>

namespace NSolomon::NFetcher {
    using TMaybeLocation = std::optional<TClusterNode>;
    class IShardLocator {
    public:
        virtual ~IShardLocator() = default;
        virtual TMaybeLocation Location(ui32 shardId) const = 0;
    };

    using IShardLocatorPtr = THolder<IShardLocator>;

    // TODO(ivanzhukov): use Ptr instead of a whole config
    using TShardDiff = TDiffBuilder<TShardId, NDb::NModel::TShardConfig>::TDiff;
    using TServiceDiff = TDiffBuilder<TServiceId, NDb::NModel::TServiceConfig>::TDiff;
    using TClusterDiff = TDiffBuilder<TClusterId, NDb::NModel::TClusterConfig>::TDiff;
    using TProviderDiff = TDiffBuilder<TProviderId, NDb::NModel::TProviderConfig>::TDiff;

    struct TAgentDiff {
        // this is a stub for now
        bool IsEmpty{false};
    };

    struct TConfigDiff {
        TShardDiff ShardDiff;
        TServiceDiff ServiceDiff;
        TClusterDiff ClusterDiff;
        TAgentDiff AgentDiff;
        TProviderDiff ProviderDiff;

        bool IsEmpty() const;
        TString ToString() const;
    };

    class IFetcherConfigFactory {
    public:
        virtual ~IFetcherConfigFactory() = default;
        virtual std::optional<TFetcherShard> GetShard(TShardId::TNumId numId) const = 0;
        virtual TVector<TFetcherShard> AllShards() const = 0;
        virtual TVector<TProviderConfigPtr> AllProviders() const = 0;
    };

    class TConfigHolder: public IFetcherConfigFactory {
    public:
        using TShardFilter = std::function<bool(const NDb::NModel::TShardConfig&)>;

        explicit TConfigHolder(IShardLocator& shardLocator, TShardFilter = DummyFilter, bool enableYasm = false);

        std::optional<TFetcherShard> GetShard(TShardId::TNumId numId) const override;
        TVector<TFetcherShard> AllShards() const override;
        TVector<TProviderConfigPtr> AllProviders() const override;

        TConfigDiff UpdateConfig(TConfigs& configs);

    private:
        std::optional<TFetcherShard> GetShardImpl(const TShardConfigPtr& shardConf) const;
        void UpdateShardMapping();

    private:
        static bool DummyFilter(const NDb::NModel::TShardConfig&) {
            return true;
        }

        using TShardMap = TMap<TString, TShardConfigPtr>;

        IShardLocator& ShardLocator_;

        THashMap<TShardId, TShardConfigPtr> Shards_;
        THashMap<TClusterId, TClusterConfigPtr> Clusters_;
        THashMap<TServiceId, TServiceConfigPtr> Services_;
        THashMap<TProviderId, TProviderConfigPtr> Providers_;

        THashMap<TServiceId, TShardMap> ServiceToShard_;
        THashMap<TClusterId, TShardMap> ClusterToShard_;

        THashSet<NDb::NModel::TAgentConfig> Agents_;
        TShardFilter Filter_;
        std::optional<TFetcherShard> YasmShard_;
    };

    bool HasClusterChanged(const NDb::NModel::TClusterConfig& lhs, const NDb::NModel::TClusterConfig& rhs);
    bool HasServiceChanged(const NDb::NModel::TServiceConfig& lhs, const NDb::NModel::TServiceConfig& rhs);
    bool HasShardChanged(const NDb::NModel::TShardConfig& lhs, const NDb::NModel::TShardConfig& rhs);
} // namespace NSolomon::NFetcher
