#pragma once

#include <solomon/services/fetcher/lib/queue/queue.h>
#include <solomon/services/fetcher/lib/metric_verbosity.h>

#include <library/cpp/monlib/metrics/ewma.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/ptr.h>

#include <unordered_map>

namespace NSolomon::NFetcher {

    class ICoremonMetrics {
    public:
        virtual ~ICoremonMetrics() = default;

        virtual void RecordResponseTime(i64 value) = 0;
        virtual void AddMetricsWritten(ui64 value) = 0;

        virtual void Success() = 0;
        virtual void Fail() = 0;
        virtual void IncInflight() = 0;
        virtual ui64 DecInflight() = 0;
        virtual void UrlQueueOverflow() = 0;
        virtual void AddMaxInflight(i64 val) = 0;

        virtual NMonitoring::TEwmaMeter CreateProcessingRateEwma() = 0;
        virtual THolder<TShardQueue::ICounters> CreateQueueCounters() = 0;
        virtual NMonitoring::IIntGauge* QueueMemEstimateCounter() = 0;
    };

    using ICoremonMetricsPtr = std::shared_ptr<ICoremonMetrics>;

    class TCounterHolder;
    class TCoremonMetricFactory {
    public:
        TCoremonMetricFactory(std::shared_ptr<NMonitoring::IMetricRegistry> shardMetrics, EMetricVerbosity verbosity);

        ICoremonMetricsPtr MetricsFor(TStringBuf projectId, TStringBuf shardId);

    private:
        std::shared_ptr<TCounterHolder> GetPerProjectMetrics(TStringBuf projectId);

    private:
        std::shared_ptr<NMonitoring::IMetricRegistry> ShardMetrics_;
        std::shared_ptr<TCounterHolder> Total_;
        THashMap<TString, std::shared_ptr<TCounterHolder>> PerProject_;
        EMetricVerbosity Verbosity_;
    };

} // namespace NSolomon::NFetcher
