#pragma once

#include "limiter.h"
#include "processing_client.h"

#include <solomon/services/fetcher/lib/data_sink/counters.h>
#include <solomon/services/fetcher/lib/metric_verbosity.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/clients/coremon/coremon_client.h>
#include <solomon/libs/cpp/clients/ingestor/ingestor_client.h>

#include <library/cpp/monlib/metrics/fwd.h>

#include <util/generic/size_literals.h>

namespace NSolomon::NFetcher {
    class IShardWriterFactory: public TThrRefBase {
    public:
        virtual NActors::IActor* CreateShardWriter(TStringBuf projectId, class TShardId shardId) = 0;
        virtual TIntrusivePtr<TGlobalLimiter> Limiter() const = 0;
    };

    using IShardWriterFactoryPtr = TIntrusivePtr<IShardWriterFactory>;

    struct TCoremonSinkConf {
        std::shared_ptr<NMonitoring::IMetricRegistry> ShardMetrics;
        i64 MemLimit{10_GB};
        EMetricVerbosity MetricVerbosity{EMetricVerbosity::All};
    };

    NActors::IActor* CreateDataSink(
        IShardWriterFactoryPtr writerFactory,
        NMonitoring::ICounter* overflows,
        ui64 executorPool = 0
    );

    IShardWriterFactoryPtr CreateShardWriterFactory(
        IProcessingClientPtr client,
        TCoremonSinkConf conf
    );
} // namespace NSolomon::NFetcher
