#pragma once

#include <solomon/services/fetcher/lib/queue/queue.h>

#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NFetcher {
    class TGlobalLimiter: public IQueueMemoryLimiter {
    public:
        TGlobalLimiter(ui64 limit, NMonitoring::IIntGauge* memory);
        bool OnWrite(ui64 bytes) override;
        void OnFree(ui64 bytes) override;

        ui64 Available() const {
            auto current = Current_.load();
            return current <= Limit_
                ? Limit_ - current
                : 0;
        }

    protected:
        const ui64 Limit_;
        std::atomic<ui64> Current_{0};
        NMonitoring::IIntGauge* Memory_;
    };

    class TShardLimiter: public IQueueMemoryLimiter {
    public:
        TShardLimiter(ui64 shardLimit, NMonitoring::IIntGauge* memory, IQueueMemoryLimiterPtr globalLimiter);
        ~TShardLimiter();

        bool OnWrite(ui64 bytes) override;
        void OnFree(ui64 bytes) override;

    private:
        const ui64 Limit_;
        IQueueMemoryLimiterPtr Global_;
        ui64 Current_{0};
        NMonitoring::IIntGauge* Memory_;
    };
} // namespace NSolomon::NFetcher
