#pragma once

#include <solomon/services/fetcher/lib/queue/queue.h>
#include <solomon/services/fetcher/lib/id.h>

#include <solomon/libs/cpp/cluster_map/cluster.h>
#include <solomon/libs/cpp/clients/coremon/coremon_client.h>
#include <solomon/libs/cpp/error_or/error_or.h>
#include <solomon/libs/cpp/clients/ingestor/ingestor_client.h>

#include <solomon/protos/common/url_info.pb.h>

#include <library/cpp/threading/future/future.h>

namespace NSolomon::NFetcher {
    struct TProcessResult {
        ui32 SuccessMetricCount;
        yandex::solomon::common::UrlStatusType Status;
        TString Error;
    };

    struct TShardAssignments {
        using THost = std::pair<TString, ui32>;

        TString Leader;
        THashMap<THost, TVector<ui32>> Assignments;
    };

    struct TShardCreated {
        TString Leader;
        TString AssignedToHost;
        TString ShardId;
        ui32 NumId{0};
    };

    using TAsyncShardAssignments = NThreading::TFuture<TErrorOr<TShardAssignments, TApiCallError>>;
    using TAsyncDataProcessResponse = NThreading::TFuture<std::vector<TErrorOr<TProcessResult, TApiCallError>>>;
    using TAsyncShardCreated = NThreading::TFuture<TErrorOr<TShardCreated, TApiCallError>>;

    /**
     * A common wrapper interface over a metric processor service.
     */
    class IProcessingClient: public TThrRefBase {
    public:
        virtual TAsyncDataProcessResponse ProcessPulledData(
            const TShardId& shardId, std::vector<TQueueEntry> entries) = 0;

        virtual TAsyncShardAssignments GetShardAssignments() noexcept = 0;

        virtual TAsyncShardCreated CreateShard(
                TString projectId,
                TString serviceName,
                TString clusterName,
                TString createdBy) noexcept = 0;

        virtual void Stop(bool) = 0;

        virtual bool IsBatchSupported() const noexcept = 0;
    };

    using IProcessingClientPtr = TIntrusivePtr<IProcessingClient>;

    class IProcessingClusterClient: public TThrRefBase {
    public:
        virtual IProcessingClientPtr GetClient(const TClusterNode& node) noexcept = 0;
        virtual IProcessingClientPtr GetAnyClient() = 0;
    };

    using IProcessingClusterClientPtr = TIntrusivePtr<IProcessingClusterClient>;

    IProcessingClientPtr WrapProcessingClient(NCoremon::ICoremonClient* coremonClient);
    IProcessingClientPtr WrapProcessingClient(NIngestor::IIngestorClient* ingestorClient);
    IProcessingClusterClientPtr WrapClusterClient(NCoremon::ICoremonClusterClientPtr cluster);
    IProcessingClusterClientPtr WrapClusterClient(NIngestor::IIngestorClusterClientPtr cluster);
} // namespace NSolomon::NFetcher
