#pragma once

#include "counters.h"
#include "processing_client.h"

#include <solomon/services/fetcher/lib/queue/queue.h>
#include <solomon/services/fetcher/lib/events.h>
#include <solomon/libs/cpp/actors/events/events.h>

#include <library/cpp/actors/core/event_local.h>

#include <solomon/libs/cpp/actors/fwd.h>

namespace NSolomon::NFetcher {

struct TShardWriterEvents: private NSolomon::TEventSlot<EEventSpace::Fetcher, FS_SHARD_WRITER> {
    enum {
        Start = SpaceBegin,
        EvWrite,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

    struct TWrite: NActors::TEventLocal<TWrite, EvWrite> {
        TWrite(TEvSinkWrite&& data, NActors::TActorId sender) {
            Entry = TQueueEntry{std::move(data), sender};
        }

        TQueueEntry Entry;
    };
};

NActors::IActor* CreateShardWriter(
        class TShardId shardId,
        IProcessingClient& client,
        ICoremonMetricsPtr counters,
        IQueueMemoryLimiterPtr limiter);

} // namespace NSolomon::NFetcher
